/*
 * Decompiled with CFR 0.152.
 */
package common.base.tools.statistics;

public class StatQpsItem {
    private String apiName;
    private String localKey;
    private String serverKey;
    private int status;
    private long count = 0L;
    private long minDurationMs = Long.MAX_VALUE;
    private long maxDurationMs = Long.MIN_VALUE;
    private double avgDurationMs = 0.0;

    public StatQpsItem(String apiName, String localKey, String serverKey, int status) {
        this.apiName = apiName;
        this.localKey = localKey;
        this.serverKey = serverKey;
        this.status = status;
    }

    public String getApiName() {
        return this.apiName;
    }

    public String getLocalKey() {
        return this.localKey;
    }

    public String getServerKey() {
        return this.serverKey;
    }

    public int getStatus() {
        return this.status;
    }

    public long getCount() {
        return this.count;
    }

    public long getMinDurationMs() {
        return this.minDurationMs;
    }

    public long getMaxDurationMs() {
        return this.maxDurationMs;
    }

    public double getAvgDurationMs() {
        return this.avgDurationMs;
    }

    public synchronized void set(long durationMs) {
        this.minDurationMs = Math.min(this.minDurationMs, durationMs);
        this.maxDurationMs = Math.max(this.maxDurationMs, durationMs);
        ++this.count;
        try {
            this.avgDurationMs += ((double)durationMs - this.avgDurationMs) / (double)this.count;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

