package common.base.tools.JSON;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParser;

public class JsonFormatTools {
    final static Gson gson = new GsonBuilder().setPrettyPrinting().create();

    /**
     * Format to pretty json string for human reading.
     *
     * @param object : Object to format.
     * @return :Pretty json string
     */
    public static String toPrettyJson(Object object) {
        return gson.toJson(object);
    }

    /**
     * Format to pretty json string for human reading.
     *
     * @param uglyJSONString : UGLY json string
     * @return :Pretty json string
     */
    public static String toPrettyJson(String uglyJSONString) {
        return gson.toJson(new JsonParser().parse(uglyJSONString));
    }
}
