package common.base.tools.consistenthash;

import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;

public class CRC32Hash implements IHashFunction {
    @Override
    public long hash(String key) {
        return Hashing.crc32().hashString(key, Charsets.UTF_8).asInt();
    }
}
