package common.base.tools.limiter;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.concurrent.atomic.AtomicLong;

public class RateCountLimiter extends AbstractRateLimiter<String, AtomicLong> {
    private static final Logger logger = LoggerFactory.getLogger(RateCountLimiter.class);
    
    public RateCountLimiter(String limiterName, int timeUnitSeconds, int maxPerTimeUnit) {
        super(limiterName, timeUnitSeconds, maxPerTimeUnit);
    }

    @Override
    public String getKey(String key) {
        if (timeUnitSeconds > 0) {
            return RateLimiterTools.getPeriodKey(key, timeUnitSeconds);
        } else {
            return key;
        }
    }

    @Override
    public long incAndGetCount(String key, AtomicLong value) {
        if (value == null) {
            value = new AtomicLong(0L);
        }

        long count = value.incrementAndGet();
        limitCache.put(key, value);
        return count;
    }

    @Override
    public long getCount(AtomicLong count) {
        if (count == null) {
            return 0;
        } else {
            return count.get();
        }
    }
}
