package common.base.tools.type;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;
import java.util.Map;

/**
 * Created by Frank.Huang on 2016/5/14.
 */
public class StringTools {
    private static final Logger logger = LoggerFactory.getLogger(StringTools.class);

    public static Map<String, String> parseAsMap(String str, String entrySeparator, String keyValueSeparator) {
        return parseAsMap2(str, entrySeparator, keyValueSeparator);
    }

    public static Map<String, String> parseAsMap2(String str, String entrySeparator, String keyValueSeparator) {
        Map<String, String> valueMap = Maps.newHashMap();
        if (!Strings.isNullOrEmpty(str)) {

            try {
                List<String> entries = Splitter.on(entrySeparator).omitEmptyStrings().trimResults().splitToList(str);
                for (String entry : entries) {
                    try {
                        List<String> values = Splitter.on(keyValueSeparator).omitEmptyStrings().trimResults().splitToList(entry);
                        if (values.size() == 2) {
                            valueMap.put(values.get(0), values.get(1));
                        }
                    } catch (Exception re) {
                        logger.error("error:[{}]-[{}]-[{}] exception:{}", str, entrySeparator, keyValueSeparator, entry);
                    }
                }
            } catch (Exception e) {
                logger.error("STR2MAP error:[{}]-[{}]-[{}] exception:{}", str, entrySeparator, keyValueSeparator, e);
            }
        }

        return valueMap;
    }

    public static List<String> parseAsList(String str, String entrySeparator) {
        if (!Strings.isNullOrEmpty(str)) {
            try {
                return Splitter.on(entrySeparator).omitEmptyStrings().trimResults().splitToList(str);
            } catch (Exception e) {
                logger.error("String To List error:[{}-{}]", str, entrySeparator);
            }
        }

        return Lists.newArrayList();
    }

    public static int toInt(String str) {
        if (Strings.isNullOrEmpty(str)) {
            return 0;
        }

        try {
            return Integer.valueOf(str);
        } catch (NumberFormatException e) {
            logger.warn("String[{}] cast to int failed:{}", str, e);
            return 0;
        }
    }


    public static String firstToUpperCase(String str) {
        if (Strings.isNullOrEmpty(str)) {
            return str;
        }

        String[] strs = str.split(" ");
        List<String> strList = Lists.newArrayList();
        for (String s : strs) {
            if (Strings.isNullOrEmpty(s)) {
                strList.add(s);
            } else {
                strList.add(s.substring(0, 1).toUpperCase() + s.substring(1));
            }
        }

        return Joiner.on(" ").join(strList);
    }


    public static boolean eq(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }

        if (s1 == null && s2 != null) {
            return false;
        }

        if (s1 != null && s2 == null) {
            return false;
        }

        return (s1.compareTo(s2) == 0);
    }

    public static String join(String split, Object... objects) {
        return Joiner.on(split).useForNull("*").join(objects);
    }

    public static String join(Object... objects) {
        return join(".", objects);
    }
}
