/*
 * Decompiled with CFR 0.152.
 */
package common.base.tools.consistenthash;

import common.base.tools.consistenthash.IHashFunction;
import common.base.tools.consistenthash.NativeHash;
import java.util.Collection;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;

public class ConsistentHash<T> {
    private final int virtualNodeCount;
    private final IHashFunction hashFunction;
    private final SortedMap<Long, T> circle = new TreeMap<Long, T>();
    public static final int VIRTUAL_NODE_COUNT = 160;

    public ConsistentHash(Collection<T> nodes, int virtualNodeCount, IHashFunction IHashFunction2) {
        this.virtualNodeCount = virtualNodeCount;
        this.hashFunction = IHashFunction2;
        nodes.forEach(e -> this.add(e));
    }

    public ConsistentHash(Collection<T> nodes, int virtualNodeCount) {
        this(nodes, virtualNodeCount, new NativeHash());
    }

    public ConsistentHash(Collection<T> nodes) {
        this(nodes, 160, new NativeHash());
    }

    public void add(T node) {
        for (int i = 0; i < this.virtualNodeCount; ++i) {
            this.circle.put(this.hashFunction.hash(node.toString() + i), node);
        }
    }

    public void remove(T node) {
        for (int i = 0; i < this.virtualNodeCount; ++i) {
            this.circle.remove(this.hashFunction.hash(node.toString() + i));
        }
    }

    public T get(String key) {
        if (this.circle.isEmpty()) {
            return null;
        }
        long hash = this.hashFunction.hash(key);
        Object node = this.circle.get(hash);
        if (Objects.nonNull(node)) {
            return (T)node;
        }
        SortedMap<Long, T> tailMap = this.circle.tailMap(hash);
        hash = tailMap.isEmpty() ? this.circle.firstKey().longValue() : tailMap.firstKey().longValue();
        node = this.circle.get(hash);
        return (T)node;
    }
}

