package common.base.tools.limiter;


import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.concurrent.TimeUnit;

public class RateLimiterCacheTools {
    private static final Logger logger = LoggerFactory.getLogger(RateLimiterCacheTools.class);

    public static <K, V> Cache<K, V> createCache(String cacheName, int timeUnitSeconds) {
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder()
            .recordStats()
            .expireAfterAccess(timeUnitSeconds, TimeUnit.SECONDS)
            .removalListener(new RemovalListener<K, V>() {
                @Override
                public void onRemoval(RemovalNotification<K, V> n) {
                    if (n.wasEvicted()) {
                        logger.info("[{}]Remove from cache[{}:{}]", cacheName, n.getKey(), n.getValue());
                    }
                }
            });
        logger.info("[{}]:{}", cacheName, cacheBuilder.toString());
        return cacheBuilder.build();
    }
}
