package common.base.tools.consistenthash.hashing;

import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import common.base.tools.consistenthash.IHashFunction;

public final class Murmur3Hash implements IHashFunction {
    @Override
    public long hash(String key) {
        return Hashing.murmur3_128().hashString(key, Charsets.UTF_8).asLong();
    }
}
