/*
 * Decompiled with CFR 0.152.
 */
package common.base.tools.consistenthash.hashing;

import common.base.tools.consistenthash.IHashFunction;

public final class FNVHash
implements IHashFunction {
    private static final long FNV_64_INIT = -3750763034362895579L;
    private static final long FNV_64_PRIME = 1099511628211L;
    private static final int FNV_32_INIT = -2128831035;
    private static final int FNV_32_PRIME = 16777619;

    public static int hash32(byte[] k) {
        int rv = -2128831035;
        int len = k.length;
        for (int i = 0; i < len; ++i) {
            rv ^= k[i];
            rv *= 16777619;
        }
        return rv;
    }

    public static long hash64(byte[] k) {
        long rv = -3750763034362895579L;
        int len = k.length;
        for (int i = 0; i < len; ++i) {
            rv ^= (long)k[i];
            rv *= 1099511628211L;
        }
        return rv;
    }

    public static int hash32(String k) {
        int rv = -2128831035;
        int len = k.length();
        for (int i = 0; i < len; ++i) {
            rv ^= k.charAt(i);
            rv *= 16777619;
        }
        return rv;
    }

    public static long hash64(String k) {
        long rv = -3750763034362895579L;
        int len = k.length();
        for (int i = 0; i < len; ++i) {
            rv ^= (long)k.charAt(i);
            rv *= 1099511628211L;
        }
        return rv;
    }

    @Override
    public long hash(String key) {
        return FNVHash.hash64(key);
    }
}

