package common.base.tools.consistenthash.hashing;

import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import common.base.tools.consistenthash.IHashFunction;

public final class KetamaHash implements IHashFunction {
    @Override
    public long hash(String key) {
        byte[] digest = MD5_16(key);
        long hashCode = ((long) (digest[3] & 0xFF) << 24)
                | ((long) (digest[2] & 0xFF) << 16)
                | ((long) (digest[1] & 0xFF) << 8)
                | (long) (digest[0] & 0xFF);
        return hashCode;
    }

    private byte[] MD5_16(String key) {
        return Hashing.hmacMd5("000".getBytes()).hashString(key, Charsets.UTF_8).asBytes();
    }
}
