package common.base.tools.statistics;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.TreeRangeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;
import java.util.Map;

/**
 * Created by Frank.Huang on 2016/5/20.
 */
public class StatRangeTools {
    private static final Logger logger = LoggerFactory.getLogger(StatRangeTools.class);
    private static RangeMap<Long, Integer> rangeMap = TreeRangeMap.create();

    static {
        initRange("");
    }

    private static List<Long> parseRangeConfig(String range) {
        List<Long> timeRangeList = Lists.newArrayList();
        try {
            if (!Strings.isNullOrEmpty(range)) {
                List<String> rangeList = Splitter.on(",").omitEmptyStrings().trimResults().splitToList(range);
                if (!rangeList.isEmpty()) {
                    for (String v : rangeList) {
                        timeRangeList.add(Long.valueOf(v));
                    }

                    if (!timeRangeList.isEmpty()) {
                        return timeRangeList;
                    }
                }
            }
        } catch (Exception e) {
            logger.error("Load Time Range Exception,Use default", e);
        }

        if (timeRangeList.isEmpty()) {
            timeRangeList.addAll(Lists.newArrayList(0L, 100L, 300L, 500L, 1000L, 3000L, 5000L));
        }


        logger.info("Load Time Range:[{}]", Joiner.on(",").join(timeRangeList));
        return timeRangeList;
    }

    private static void initRange(String range) {
        rangeMap.clear();
        List<Long> timeRange = parseRangeConfig(range);
        int maxLevel = timeRange.size();
        for (int i = 0; i < maxLevel; i++) {
            if (i < maxLevel - 1) {
                rangeMap.put(Range.closedOpen(timeRange.get(i), timeRange.get(i + 1)), i);
            } else {
                rangeMap.put(Range.atLeast(timeRange.get(i)), i);
            }

        }
    }

    public static int getLevel(long val) {
        return rangeMap.get(val);
    }

    public static String getRangeName(int level) {
        for (Map.Entry<Range<Long>, Integer> entry : rangeMap.asMapOfRanges().entrySet()) {
            if (level == entry.getValue()) {
                return entry.getKey().toString();
            }
        }

        return "unknown";
    }
}
