package common.base.tools.type;

import com.google.common.base.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Created by Frank.Huang on 2016/7/27.
 */
public class LangTools {
    private static final Logger logger = LoggerFactory.getLogger(LangTools.class);

    public static String LANG_PT = "pt";
    public static String LANG_ES = "es";
    public static String LANG_EN = "en";
    /*
     * 未来电视支持中文
     */
    public static String LANG_ZH = "zh";
    /**
     * 4.0支持印尼语
     */
    public static String LANG_IN = "in";
    public static String LANG_ES_TMDB_ALIAS = "spa";


    public static boolean isPortuguese(String language) {
        return LANG_PT.equalsIgnoreCase(language);
    }

    public static boolean isSpanish(String language) {
        return LANG_ES.equalsIgnoreCase(language);
    }

    public static boolean isEnglish(String language) {
        return LANG_EN.equalsIgnoreCase(language);
    }

    public static boolean isChinese(String language) {
        return LANG_ZH.equalsIgnoreCase(language);
    }

    public static boolean isIndonesian(String language) {
        return LANG_IN.equalsIgnoreCase(language);
    }

    public static boolean isSupportLanguage(String language) {
        return isEnglish(language) || isPortuguese(language) || isSpanish(language) || isChinese(language) || isIndonesian(language);
    }

    public static String spanishAlias(String language) {
        if (LANG_ES_TMDB_ALIAS.equalsIgnoreCase(language)) {
            return LANG_ES;
        } else {
            return language;
        }
    }

    public static boolean equalLanguage(String lang1, String lang2) {
        if (Strings.isNullOrEmpty(lang1) || Strings.isNullOrEmpty(lang2)) {
            return false;
        }

        if (lang1.equalsIgnoreCase(lang2)) {
            return true;
        }

        if (isEnglish(lang1) || isEnglish(lang2)) {
            if (spanishAlias(lang1).equalsIgnoreCase(spanishAlias(lang2))) {
                return true;
            }
        }

        return false;
    }

    public static String getOrDefaultLanguage(String language) {
        if (isSupportLanguage(language)) {
            return language;
        } else {
            return LangTools.LANG_EN;
        }
    }
}
