package common.base.tools.statistics;

import java.util.Objects;

/**
 * @author Administrator
 */
public class ServiceStatisticItem {

    private String apiName;
    private String serverAddress;
    private String serverPort;
    private String httpResponseCode;
    private String errCode;
    private String errMsg;

    public String getApiName() {
        return apiName;
    }

    public void setApiName(String apiName) {
        this.apiName = apiName;
    }

    public String getServerAddress() {
        return serverAddress;
    }

    public void setServerAddress(String serverAddress) {
        this.serverAddress = serverAddress;
    }

    public String getServerPort() {
        return serverPort;
    }

    public void setServerPort(String serverPort) {
        this.serverPort = serverPort;
    }

    public String getHttpResponseCode() {
        return httpResponseCode;
    }

    public void setHttpResponseCode(String httpResponseCode) {
        this.httpResponseCode = httpResponseCode;
    }

    public String getErrCode() {
        return errCode;
    }

    public void setErrCode(String errCode) {
        this.errCode = errCode;
    }

    public String getErrMsg() {
        return errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    @Override
    public int hashCode() {
        int result = 17;
        result = 31 * result + (this.apiName == null ? 0 : this.apiName.hashCode());
        result = 31 * result + (this.serverAddress == null ? 0 : this.serverAddress.hashCode());
        result = 31 * result + (this.serverPort == null ? 0 : this.serverPort.hashCode());
        result = 31 * result + (this.httpResponseCode == null ? 0 : this.httpResponseCode.hashCode());
        result = 31 * result + (this.errCode == null ? 0 : this.errCode.hashCode());
        result = 31 * result + (this.errMsg == null ? 0 : this.errMsg.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != getClass()) {
            return false;
        }
        ServiceStatisticItem other = (ServiceStatisticItem) obj;
        if (!Objects.equals(other.apiName, apiName) || !Objects.equals(other.serverAddress, serverAddress)
                || !Objects.equals(other.serverPort, serverPort) || !Objects.equals(other.httpResponseCode, httpResponseCode)
                || !Objects.equals(other.errCode, errCode) || !Objects.equals(other.errMsg, errMsg)) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return "ServiceStatisticItem{" +
                "apiName='" + apiName + '\'' +
                ", serverAddress='" + serverAddress + '\'' +
                ", serverPort='" + serverPort + '\'' +
                ", httpResponseCode='" + httpResponseCode + '\'' +
                ", errCode='" + errCode + '\'' +
                ", errMsg='" + errMsg + '\'' +
                '}';
    }
}
