package common.base.tools.encrypt;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

import static common.base.tools.encrypt.ByteHexUtils.byte2hex;

/**
 * Created by Frank.Huang on 2016/6/4.
 */
@Deprecated
public class SHA {
    private static final Logger logger = LoggerFactory.getLogger(SHA.class);

    MessageDigest digest = null;
    public SHA() {
        try {
            digest = MessageDigest.getInstance("SHA-1");
        } catch (NoSuchAlgorithmException e) {
            logger.error("SHA EXP:{}",e);
        }
    }

    public void update(String content) {
        if (digest != null){
            try {
                digest.update(content.getBytes("UTF-8"));
            } catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    public String checksum(){
        if (digest==null){
            return "";
        }

        return byte2hex(digest.digest(),false);
    }

    public String base64Checksum(){
        if (digest==null){
            return "";
        }

        return Base64Utils.encodeURLSafe(digest.digest());
    }


    public static String sha1(String content){
        SHA sha = new SHA();
        sha.update(content);
        return sha.checksum();
    }

    public static String sha1Base64(String content){
        SHA sha = new SHA();
        sha.update(content);
        return sha.base64Checksum();
    }
}
