package common.base.tools.stat;

/**
 * Created by Frank.Huang on 2016/5/10.
 */
public class StatTools {
    public synchronized static void addReq(String key) {
        CountStatisticsTools.addReq(key);
    }
    public synchronized static void addRsp(String key) {
        CountStatisticsTools.addRsp(key);
    }
    public synchronized static void addErr(String key) {
        CountStatisticsTools.addError(key);
    }

    public static void  report2Remote(boolean count2remote,boolean timeCousumed2remote){
        CountStatisticsTools.report2Remote(count2remote);
        TimeStatisticsTools.report2Remote(timeCousumed2remote);
    }
    public synchronized static void startTimer(String key) {
        TimeStatisticsTools.startTimer(key);
    }

    public synchronized static long stopTimer(String key) {
        return TimeStatisticsTools.stopTimer(key);
    }
    public synchronized static void startApiTimer(String key) {
        TimeStatisticsTools.startTimer("api-" + key);
    }

    public synchronized static long stopApiTimer(String key) {
        return TimeStatisticsTools.stopTimer("api-" + key);
    }

    public synchronized static void startSrvTimer(String key) {
        TimeStatisticsTools.startTimer("srv-" + key);
    }

    public synchronized static long stopSrvTimer(String key) {
        return TimeStatisticsTools.stopTimer("srv-" + key);
    }

    public synchronized static void startMethodTimer(String key) {
        TimeStatisticsTools.startTimer("m-" + key);
    }

    public synchronized static long stopMethodTimer(String key) {
        return TimeStatisticsTools.stopTimer("m-" + key);
    }
    
    public synchronized static void startDBTimer(String key) {
        TimeStatisticsTools.startTimer("db-" + key);
    }

    public synchronized static long stopDBTimer(String key) {
        return TimeStatisticsTools.stopTimer("db-" + key);
    }

    public synchronized static void startPrtTimer(String key) {
        TimeStatisticsTools.startTimer(key);
    }

    public synchronized static long stopPrtTimer(String key) {
        return TimeStatisticsTools.stopTimer(key,false);
    }


    public synchronized static String dumpMutilline(boolean isSummary) {
        StringBuilder sb = new StringBuilder();
        sb.append(CountStatisticsTools.dumpMutilLine(isSummary));
        sb.append(TimeStatisticsTools.dumpMutilline());

        return sb.toString();
    }
}
