/*
 * Decompiled with CFR 0.152.
 */
package common.base.tools.multithread;

import common.base.tools.multithread.IChangedProcessor;
import common.base.tools.multithread.IChangedProcessorFactory;
import common.base.tools.multithread.IChangedRunner;
import java.util.concurrent.BlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangedRunner2
implements IChangedRunner {
    private static final Logger logger = LoggerFactory.getLogger(ChangedRunner2.class);
    private BlockingQueue queue;
    private IChangedProcessorFactory changedProcessorFactory;

    public ChangedRunner2(BlockingQueue queue, IChangedProcessorFactory processorFactory) {
        this.queue = queue;
        this.changedProcessorFactory = processorFactory;
        if (this.changedProcessorFactory == null) {
            throw new IllegalArgumentException("Processor is null.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object element = this.queue.poll();
        while (element != null) {
            IChangedProcessor changedProcessor = this.changedProcessorFactory.getProcessor();
            if (changedProcessor.isReady(element)) {
                try {
                    changedProcessor.onStart(element);
                    changedProcessor.onChanged(element);
                }
                catch (Exception e) {
                    changedProcessor.onError(element, e);
                }
                finally {
                    changedProcessor.onEnd(element);
                }
            }
            element = this.queue.poll();
        }
    }
}

