/*
 * Decompiled with CFR 0.152.
 */
package common.base.tools.stat;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.metric.client.MetricAgent;
import com.metric.client.MetricConfig;
import common.base.tools.type.DateTimeTools;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class MetricTools {
    private static final Logger logger = LoggerFactory.getLogger(MetricTools.class);
    public static String ENV_METRIC_SERVER = "metric.server";
    public static String ENV_METRIC_THREAD_POOL_SIZE = "metric.thread.pool.size";
    public static String ENV_METRIC_BUFFER_QUEUE_SIZE = "metric.buffer.queue.size";
    public static String ENV_METRIC_POST_BATCH_SIZE = "metric.post.batch.size";
    private static String metricTable = "";
    private static final String METRIC_COUNT_SUFFIX = "_count";
    private static final String METRIC_TIME_SUFFIX = "_timeconsumed";
    private static final String METRIC_API_CALL = "_apicall";
    private static final String METRIC_QUEUE = "_queuesize";
    private static final String METRIC_ES_TIME = "_es_time";
    private static final String METRIC_ES_COUNT = "_es_time";
    private static boolean bInit = false;

    public static void setDebug(boolean debug) {
        MetricAgent.setDebug((boolean)debug);
    }

    public static void init(String appId, String appKey, String metricServer, int threadPoolSize, int bufferQueueSize, int postBatchSize) {
        if (Strings.isNullOrEmpty((String)metricServer)) {
            logger.warn("Metric:[{}] [{}] Cannot get remote metricServer,ignore report to remote.", (Object)appId, (Object)appKey);
            return;
        }
        MetricConfig metricConfig = new MetricConfig();
        metricConfig.setAppId(appId);
        metricConfig.setAppKey(appKey);
        metricConfig.setServerUrl(metricServer);
        if (threadPoolSize > 0) {
            metricConfig.setThreadPoolSize(threadPoolSize);
        }
        if (bufferQueueSize > 0) {
            metricConfig.setBufferQueueSize(bufferQueueSize);
        }
        if (postBatchSize > 0) {
            metricConfig.setPostBatchSize(postBatchSize);
        }
        MetricAgent.init((MetricConfig)metricConfig);
        bInit = true;
        metricTable = appId;
        logger.info("Metric:[{}] [{}] [{}] [{}] [{}] [{}]", new Object[]{metricConfig.getAppId(), metricConfig.getAppKey(), metricConfig.getServerUrl(), metricConfig.getThreadPoolSize(), metricConfig.getBufferQueueSize(), metricConfig.getPostBatchSize()});
    }

    public static void postEvent(String metricName, Map<String, String> tags, Map<String, Object> fields) {
        try {
            if (bInit) {
                MetricAgent.postEvent((String)metricName, tags, fields);
            }
        }
        catch (Exception e) {
            logger.error("Report2Metric error. tags[{}] value[{}] ex[{}]", new Object[]{tags, fields, e});
        }
    }

    public static void logCount(String item, Map countMap) {
        String metricName = metricTable + METRIC_COUNT_SUFFIX;
        MetricTools.postEvent(metricName, (Map<String, String>)ImmutableMap.of((Object)"item", (Object)item), countMap);
    }

    public static void logTimeConsumed(String item, long value) {
        String metricName = metricTable + METRIC_TIME_SUFFIX;
        MetricTools.postEvent(metricName, (Map<String, String>)ImmutableMap.of((Object)"item", (Object)item), (Map<String, Object>)ImmutableMap.of((Object)"count", (Object)1, (Object)"time_consumed", (Object)value));
    }

    public static void logApiCall(Map<String, String> tags, Map<String, Object> fields) {
        MetricTools.postEvent(metricTable + METRIC_API_CALL, tags, fields);
    }

    public static void logESTime(String type, String opType, int count, long value) {
        String metricName = metricTable + "_es_time";
        MetricTools.postEvent(metricName, (Map<String, String>)ImmutableMap.of((Object)"type", (Object)type, (Object)"op", (Object)opType), (Map<String, Object>)ImmutableMap.of((Object)"count", (Object)count, (Object)"time_consumed", (Object)value));
    }

    public static void logQueueSize(String queue, String item, long size) {
        String metricName = metricTable + METRIC_QUEUE;
        String queueName = (queue + "_" + item).replace("-", "_");
        MetricTools.postEvent(metricName, (Map<String, String>)ImmutableMap.of((Object)"t_queue", (Object)queueName), (Map<String, Object>)ImmutableMap.of((Object)"f_size", (Object)size));
    }

    public static void reportActivated(String clientIp, String did, int userStatus, String ccType, String ccMethod, String ccStatus) {
        String metricName = metricTable + "_cc";
        ImmutableMap tags = new ImmutableMap.Builder().put((Object)"m_client_ip", (Object)clientIp).put((Object)"t_user_status", (Object)(userStatus + "")).put((Object)"t_method", (Object)ccMethod).put((Object)"t_status", (Object)ccStatus).put((Object)"t_cct", (Object)ccType).put((Object)"t_cc_date", (Object)DateTimeTools.currentDateStr2()).build();
        MetricTools.postEvent(metricName, (Map<String, String>)tags, (Map<String, Object>)ImmutableMap.of((Object)"f_did", (Object)did, (Object)"f_ccts", (Object)System.currentTimeMillis()));
    }

    public static void reportLAC(String did, String clientIp, String clientRegion, boolean isPremit) {
        if (isPremit) {
            return;
        }
        try {
            String metricName = metricTable + "_LAC";
            ImmutableMap tags = new ImmutableMap.Builder().put((Object)"m_client_ip", (Object)clientIp).put((Object)"m_client_region", (Object)clientRegion).put((Object)"t_cc_date", (Object)DateTimeTools.currentDateStr2()).build();
            MetricTools.postEvent(metricName, (Map<String, String>)tags, (Map<String, Object>)ImmutableMap.of((Object)"f_did", (Object)did));
        }
        catch (Exception e) {
            logger.error("reportLAC exception:{}", (Object)e.getMessage());
        }
    }
}

