package common.base.tools.encrypt;

/**
 * Created by Frank.Huang on 2016/7/8.
 */
public class RSABase64Utils extends RSAUtils {
    
    public static boolean verify(String data, String key, String sign) throws Exception {

        return verify(Base64Utils.decodeAsByteArray(data),
                        Base64Utils.decodeAsByteArray(key),
                        Base64Utils.decodeAsByteArray(sign));
    }

    public static String sign(String data, String key) throws Exception {
        return Base64Utils.encodeURLSafe(sign(Base64Utils.decodeAsByteArray(data), Base64Utils.decodeAsByteArray(key)));
    }

    public static byte[] decryptByPublicKey(String data, String key) throws Exception {
        return decryptByPublicKey(Base64Utils.decodeAsByteArray(data) ,Base64Utils.decodeAsByteArray(key));

    }

    public static byte[] decryptByPrivateKey(String data, String key) throws Exception {
        return decryptByPrivateKey(Base64Utils.decodeAsByteArray(data) ,Base64Utils.decodeAsByteArray(key));

    }
    public static String decrypt2Base64ByPrivateKey(String data, String key) throws Exception {
        return Base64Utils.encodeURLSafe(decryptByPrivateKey(data,key));
    }

    public static String decrypt2Base64ByPublicKey(String data, String key) throws Exception {
        return Base64Utils.encodeURLSafe(decryptByPublicKey(data,key));
    }

    public static String encriptByPrivateKey(byte[] data, String key) throws Exception {
        byte[] bytesKey = Base64Utils.decodeAsByteArray(key);
        return Base64Utils.encodeURLSafe(encryptByPrivateKey(data,bytesKey));
    }

    public static String encriptByPublicKey(byte[] data, String key) throws Exception {
        byte[] bytesKey = Base64Utils.decodeAsByteArray(key);
        return Base64Utils.encodeURLSafe(encryptByPublicKey(data,bytesKey));
    }
}
