package common.base.tools.encrypt;

import com.google.common.base.Strings;
import org.apache.commons.lang3.StringUtils;

public class Base62Tools {
    private static final char[] BASE62_CHARSETS = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
        'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z',
        'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};

    /**
     * 62进制字符转换10进制数值
     * 这里判断不严谨，没有判断字符串合法性和越界问题（转换成long之后越界）
     *
     * @param value :字符串只能包含0-9,a-z,A-Z的字符
     * @return
     */
    public static long base62ToLong(String value) {
        long v = 0;
        if (!Strings.isNullOrEmpty(value)) {
            char[] chars = StringUtils.reverse(value).toCharArray();
            for (int i = 0; i < chars.length; i++) {
                int asc = chars[i];
                int n = 0;
                if (asc >= 48 && asc <= 57) {
                    n = asc - 48;
                } else if (asc >= 97 && asc <= 122) {
                    n = asc - 87;
                } else if (asc >= 65 && asc <= 90) {
                    n = asc - 29;
                }
                v += (long) (Math.pow(BASE62_CHARSETS.length, i) * n);
            }
        }


        return v;
    }

    /**
     * 10进制数值转换62进制字符
     *
     * @param num
     * @return
     */
    public static String longToBase62(long num) {
        StringBuilder value = new StringBuilder();
        while (true) {
            int n = (int) (num % BASE62_CHARSETS.length);
            num = (num - n) / BASE62_CHARSETS.length;
            value.append(BASE62_CHARSETS[n]);
            if (num <= 0)
                break;
        }

        return value.reverse().toString();
    }

    /**
     * 10进制数值转换62进制字符
     *
     * @param id
     * @return
     */
    public static String longToBase62(String id) {
        try {
            long idLong = Long.valueOf(id);
            return longToBase62(idLong);
        } catch (Exception e) {
            return id;
        }
    }
}
