package common.base.tools.encrypt;


import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

/**
 *
 */
public class AESIVTools {
    private static final Logger logger = LoggerFactory.getLogger(AESIVTools.class);
    /**
     * Encrypt
     *
     * @param input
     * @param key
     * @param iv
     * @return
     */
    public static byte[] encrypt(byte[] input, byte[] key, byte[] iv) {
        byte[] crypted = null;
        try {
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            SecretKeySpec skey = new SecretKeySpec(key, "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(Cipher.ENCRYPT_MODE, skey, ivSpec);
            crypted = cipher.doFinal(input);
        } catch (Exception e) {
            logger.error("AESIVTools.encrypt", e);
        }
        return crypted;
    }

    /**
     * Decrypt
     *
     * @param input
     * @param key
     * @param iv
     * @return
     */
    public static byte[] decrypt(byte[] input, byte[] key, byte[] iv) {
        try {
            byte[] output = null;
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            SecretKeySpec skey = new SecretKeySpec(key, "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(Cipher.DECRYPT_MODE, skey, ivSpec);
            output = cipher.doFinal(input);
            return output;
        } catch (Exception e) {
            logger.error("AESIVTools.decrypt", e);
            return null;
        }

    }

    /**
     * Encrypt
     *
     * @param input
     * @param key
     * @param iv
     * @return
     */
    public static String encrypt(String input, String key, String iv) {
        byte[] keyBytes = Base64.decodeBase64(key);
        byte[] crypted = encrypt(input.getBytes(), keyBytes, iv.getBytes());
        return Base64.encodeBase64URLSafeString(crypted);
    }

    /**
     * Decrypt
     *
     * @param input
     * @param key
     * @param iv
     * @return
     */
    public static String decrypt(String input, String key, String iv) {
        byte[] inputBytes = Base64.decodeBase64(input);
        byte[] keyBytes = Base64.decodeBase64(key);

        byte[] bytes = decrypt(inputBytes, keyBytes, iv.getBytes());
        if (bytes != null) {
            return new String(bytes);
        }
        return null;
    }
}