package common.base.tools.statistics;

import com.google.common.base.Strings;
import com.metric.client.MetricAgent;
import com.metric.client.MetricConfig;
import com.valor.mercury.sender.service.MercurySender;
import common.base.tools.type.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by Frank.Huang on 2017/2/8.
 */
public class MetricTools2 {
    private static final Logger logger = LoggerFactory.getLogger(MetricTools2.class);

    private static boolean bInit = false;

    private static boolean MercuryInit = false;

    public static void setDebug(boolean debug) {
        MetricAgent.setDebug(debug);
    }


    public static void init(String appId,
                            String appKey,
                            String metricServer,
                            int threadPoolSize,
                            int bufferQueueSize,
                            int postBatchSize) {

        if (Strings.isNullOrEmpty(metricServer)) {
            logger.warn("Metric:[{}] [{}] Cannot get remote metricServer,ignore report to remote.", appId, appKey);
            return;
        }

        MetricConfig metricConfig = new MetricConfig();
        metricConfig.setAppId(appId);
        metricConfig.setAppKey(appKey);
        metricConfig.setServerUrl(metricServer);

        if (threadPoolSize > 0) {
            metricConfig.setThreadPoolSize(threadPoolSize);
        }

        if (bufferQueueSize > 0) {
            metricConfig.setBufferQueueSize(bufferQueueSize);
        }

        if (postBatchSize > 0) {
            metricConfig.setPostBatchSize(postBatchSize);
        }

        MetricAgent.init(metricConfig);
        bInit = true;
        logger.info("Metric:[{}] [{}] [{}] [{}] [{}] [{}]",
                metricConfig.getAppId(), metricConfig.getAppKey(), metricConfig.getServerUrl(),
                metricConfig.getThreadPoolSize(), metricConfig.getBufferQueueSize(), metricConfig.getPostBatchSize());
    }


    public static void initMercury(String urls, String appId, String appKey, boolean forClientUse) {

        if (Strings.isNullOrEmpty(urls)) {
            logger.warn("MercurySender:[{}] [{}] Cannot get remote metricServer,ignore report to remote.", appId,
                    appKey);
            return;
        }
        Map<String, String[]> servers = new HashMap<>();
        servers.put(appId, urls.split(","));
        MercuryInit = true;
        MercurySender.init(servers, appId, appKey, forClientUse);
        logger.info("Mercury:[{}] [{}] [{}]", urls, appId, appKey);
    }


    public static void postEvent(String metricName, Map<String, String> tags, Map<String, Object> fields) {
        try {
            if (bInit) {
                MetricAgent.postEvent(metricName, tags, fields);
            } else {
                logger.warn("Metric not init");
            }

        } catch (Exception e) {
            //上报异常不影响正常业务
            logger.error("Metric post event expire.metricName[{}] tags[{}] value[{}] ex[{}]",
                    metricName, tags, fields, e);
        }
    }

    public static void postMercuryEvent(String key, String eventName, Map<String, Object> fieldsMap) {
        try {
            if (MercuryInit) {
                MercurySender.put(key, eventName, fieldsMap);
            } else {
                logger.warn("Mercury not init");
            }

        } catch (Exception e) {
            //上报异常不影响正常业务
            logger.error("Mercury post event expire.key[{}] eventName[{}] fieldsMap[{}] ex[{}]",
                    key, eventName, fieldsMap, e);
        }
    }
}
