/*
 * Decompiled with CFR 0.152.
 */
package common.base.tools.token.serializer;

import com.google.common.collect.Maps;
import common.base.tools.token.TokenObject;
import common.base.tools.token.serializer.ByteBufferBuilder;
import common.base.tools.token.serializer.ITokenSerializer;
import java.util.LinkedHashMap;
import java.util.List;

public class TokenBinSerializer
implements ITokenSerializer {
    @Override
    public String serializer(TokenObject tokenObject) {
        ByteBufferBuilder bbb = new ByteBufferBuilder();
        tokenObject.getValueMap().forEach((k, v) -> bbb.put((String)k, v));
        return new String(bbb.getAndReset());
    }

    @Override
    public TokenObject deserializer(String tokenString, TokenObject tokenObject) {
        ByteBufferBuilder bbb = new ByteBufferBuilder(tokenString.getBytes());
        LinkedHashMap valueMap = Maps.newLinkedHashMap();
        List valueList = bbb.readToList();
        for (int i = 0; i < valueList.size(); ++i) {
            String key = (String)valueList.get(i);
            Object value = valueList.get(++i);
            valueMap.put(key, value);
        }
        if (tokenObject == null) {
            tokenObject = new TokenObject();
        }
        tokenObject.setValueMap(valueMap);
        return tokenObject;
    }
}

