/*
 * Decompiled with CFR 0.152.
 */
package common.base.tools.statistics;

import com.google.common.collect.Maps;
import common.base.tools.statistics.ApiRequestInfo;
import common.base.tools.statistics.QpsItem;
import common.base.tools.statistics.ServiceStatisticItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

public class ApiQpsStatisticsTools {
    private static final Logger logger = LoggerFactory.getLogger(ApiQpsStatisticsTools.class);
    private static Map<ServiceStatisticItem, QpsItem> visitMap = new ConcurrentHashMap<ServiceStatisticItem, QpsItem>();
    private static Map<Integer, ServiceStatisticItem> serverStatisticMap = Collections.synchronizedMap(new HashMap());
    private static Map<ServiceStatisticItem, Boolean> lock = new ConcurrentHashMap<ServiceStatisticItem, Boolean>();
    private static LinkedBlockingQueue<ApiRequestInfo> requestSummary = new LinkedBlockingQueue();

    public static void addVisits(ApiRequestInfo apiRequestInfo) {
        ServiceStatisticItem statisticItem = new ServiceStatisticItem();
        statisticItem.setApiName(apiRequestInfo.getApiName());
        statisticItem.setServerAddress(apiRequestInfo.getServerAddress());
        statisticItem.setServerPort(apiRequestInfo.getServerPort());
        statisticItem.setHttpResponseCode(apiRequestInfo.getHttpResponseCode());
        statisticItem.setErrCode(apiRequestInfo.getErrCode());
        statisticItem.setErrMsg(apiRequestInfo.getErrMsg());
        statisticItem.setArriveTime(apiRequestInfo.getArriveTime());
        int hashCode = statisticItem.hashCode();
        ServiceStatisticItem statistic = serverStatisticMap.putIfAbsent(hashCode, statisticItem);
        if (statistic == null) {
            statistic = statisticItem;
        }
        QpsItem qpsItem = visitMap.computeIfAbsent(statistic, s -> new QpsItem());
        lock.putIfAbsent(statistic, new Boolean(true));
        ApiQpsStatisticsTools.updateVisitInfo(statistic, qpsItem, apiRequestInfo.getDuration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateVisitInfo(ServiceStatisticItem statisticItem, QpsItem qpsItem, long duration) {
        Boolean bl = lock.get(statisticItem);
        synchronized (bl) {
            qpsItem.setVisitCount(qpsItem.getVisitCount() + 1);
            if (String.valueOf(HttpStatus.OK.value()).equals(statisticItem.getHttpResponseCode())) {
                qpsItem.setArriveTime(Math.min(qpsItem.getArriveTime(), statisticItem.getArriveTime()));
                qpsItem.setMaxDurationMs(Math.max(qpsItem.getMaxDurationMs(), duration));
                qpsItem.setMinDurationMs(Math.min(qpsItem.getMinDurationMs(), duration));
                qpsItem.setAvgDurationMs(qpsItem.getAvgDurationMs() + ((double)duration - qpsItem.getAvgDurationMs()) / (double)qpsItem.getVisitCount());
            }
        }
    }

    public static Map<ServiceStatisticItem, QpsItem> getAndResetVisit() {
        Map<ServiceStatisticItem, QpsItem> old = visitMap;
        visitMap = Maps.newConcurrentMap();
        serverStatisticMap = Maps.newConcurrentMap();
        return old;
    }

    public static void statisticRequests(String apiName, String serverAddress, String serverPort, String httpResponseCode, String errCode, String errMsg, long duration) {
        ApiRequestInfo apiRequestInfo = new ApiRequestInfo();
        apiRequestInfo.setApiName(apiName);
        apiRequestInfo.setServerAddress(serverAddress);
        apiRequestInfo.setServerPort(serverPort);
        apiRequestInfo.setHttpResponseCode(httpResponseCode);
        apiRequestInfo.setErrCode(errCode);
        apiRequestInfo.setErrMsg(errMsg);
        apiRequestInfo.setDuration(duration);
        apiRequestInfo.setArriveTime(System.currentTimeMillis());
        requestSummary.add(apiRequestInfo);
    }

    public static List<ApiRequestInfo> getRequestSummary() {
        ArrayList<ApiRequestInfo> list = new ArrayList<ApiRequestInfo>();
        requestSummary.drainTo(list);
        return list;
    }
}

