/*
 * Decompiled with CFR 0.152.
 */
package common.base.tools.statistics;

import com.google.common.base.Strings;
import com.metric.client.MetricAgent;
import com.metric.client.MetricConfig;
import common.base.tools.mercury.sender.service.MercurySender;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricTools2 {
    private static final Logger logger = LoggerFactory.getLogger(MetricTools2.class);
    private static boolean bInit = false;
    private static boolean MercuryInit = false;

    public static void setDebug(boolean debug) {
        MetricAgent.setDebug((boolean)debug);
    }

    public static void init(String appId, String appKey, String metricServer, int threadPoolSize, int bufferQueueSize, int postBatchSize) {
        if (Strings.isNullOrEmpty((String)metricServer)) {
            logger.warn("Metric:[{}] [{}] Cannot get remote metricServer,ignore report to remote.", (Object)appId, (Object)appKey);
            return;
        }
        MetricConfig metricConfig = new MetricConfig();
        metricConfig.setAppId(appId);
        metricConfig.setAppKey(appKey);
        metricConfig.setServerUrl(metricServer);
        if (threadPoolSize > 0) {
            metricConfig.setThreadPoolSize(threadPoolSize);
        }
        if (bufferQueueSize > 0) {
            metricConfig.setBufferQueueSize(bufferQueueSize);
        }
        if (postBatchSize > 0) {
            metricConfig.setPostBatchSize(postBatchSize);
        }
        MetricAgent.init((MetricConfig)metricConfig);
        bInit = true;
        logger.info("Metric:[{}] [{}] [{}] [{}] [{}] [{}]", new Object[]{metricConfig.getAppId(), metricConfig.getAppKey(), metricConfig.getServerUrl(), metricConfig.getThreadPoolSize(), metricConfig.getBufferQueueSize(), metricConfig.getPostBatchSize()});
    }

    public static void initMercury(String urls, String appId, String appKey, boolean forClientUse) {
        if (Strings.isNullOrEmpty((String)urls)) {
            logger.warn("MercurySender:[{}] [{}] Cannot get remote metricServer,ignore report to remote.", (Object)appId, (Object)appKey);
            return;
        }
        HashMap<String, String[]> servers = new HashMap<String, String[]>();
        servers.put(appId, urls.split(","));
        MercuryInit = true;
        MercurySender.init(servers, appId, appKey, forClientUse);
        logger.info("Mercury:[{}] [{}] [{}]", new Object[]{urls, appId, appKey});
    }

    public static void postEvent(String metricName, Map<String, String> tags, Map<String, Object> fields) {
        try {
            if (bInit) {
                MetricAgent.postEvent((String)metricName, tags, fields);
            } else {
                logger.warn("Metric not init");
            }
        }
        catch (Exception e) {
            logger.error("Metric post event expire.metricName[{}] tags[{}] value[{}] ex[{}]", new Object[]{metricName, tags, fields, e});
        }
    }

    public static void postMercuryEvent(String key, String eventName, Map<String, Object> fieldsMap) {
        try {
            if (MercuryInit) {
                MercurySender.put(key, eventName, fieldsMap);
            } else {
                logger.warn("Mercury not init");
            }
        }
        catch (Exception e) {
            logger.error("Mercury post event expire.key[{}] eventName[{}] fieldsMap[{}] ex[{}]", new Object[]{key, eventName, fieldsMap, e});
        }
    }
}

