/*
 * Decompiled with CFR 0.152.
 */
package common.base.tools.statistics;

import com.google.common.base.Strings;
import com.metric.client.MetricAgent;
import com.metric.client.MetricConfig;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricTools2 {
    private static final Logger logger = LoggerFactory.getLogger(MetricTools2.class);
    private static boolean bInit = false;

    public static void setDebug(boolean debug) {
        MetricAgent.setDebug((boolean)debug);
    }

    public static void init(String appId, String appKey, String metricServer, int threadPoolSize, int bufferQueueSize, int postBatchSize) {
        if (Strings.isNullOrEmpty((String)metricServer)) {
            logger.warn("Metric:[{}] [{}] Cannot get remote metricServer,ignore report to remote.", (Object)appId, (Object)appKey);
            return;
        }
        MetricConfig metricConfig = new MetricConfig();
        metricConfig.setAppId(appId);
        metricConfig.setAppKey(appKey);
        metricConfig.setServerUrl(metricServer);
        if (threadPoolSize > 0) {
            metricConfig.setThreadPoolSize(threadPoolSize);
        }
        if (bufferQueueSize > 0) {
            metricConfig.setBufferQueueSize(bufferQueueSize);
        }
        if (postBatchSize > 0) {
            metricConfig.setPostBatchSize(postBatchSize);
        }
        MetricAgent.init((MetricConfig)metricConfig);
        bInit = true;
        logger.info("Metric:[{}] [{}] [{}] [{}] [{}] [{}]", new Object[]{metricConfig.getAppId(), metricConfig.getAppKey(), metricConfig.getServerUrl(), metricConfig.getThreadPoolSize(), metricConfig.getBufferQueueSize(), metricConfig.getPostBatchSize()});
    }

    public static void postEvent(String metricName, Map<String, String> tags, Map<String, Object> fields) {
        try {
            if (bInit) {
                MetricAgent.postEvent((String)metricName, tags, fields);
            } else {
                logger.warn("Metric not init");
            }
        }
        catch (Exception e) {
            logger.error("Metric post event expire.metricName[{}] tags[{}] value[{}] ex[{}]", new Object[]{metricName, tags, fields, e});
        }
    }
}

