/*
 * Decompiled with CFR 0.152.
 */
package common.base.tools.statistics;

import com.google.common.collect.Maps;
import common.base.tools.statistics.QpsItem;
import common.base.tools.statistics.ServiceStatisticItem;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

public class ApiQpsStatisticsTools {
    private static final Logger logger = LoggerFactory.getLogger(ApiQpsStatisticsTools.class);
    private static Map<ServiceStatisticItem, QpsItem> visitMap = new ConcurrentHashMap<ServiceStatisticItem, QpsItem>();
    private static Map<Integer, ServiceStatisticItem> serverStatisticMap = Collections.synchronizedMap(new HashMap());
    private static Map<ServiceStatisticItem, Boolean> lock = new ConcurrentHashMap<ServiceStatisticItem, Boolean>();

    public static void addVisits(String apiName, String serverAddress, String serverPort, String httpResponseCode, String errCode, String errMsg, long duration) {
        ServiceStatisticItem statisticItem = new ServiceStatisticItem(apiName, serverAddress, serverPort, httpResponseCode, errCode, errMsg);
        int hashCode = statisticItem.hashCode();
        ServiceStatisticItem statistic = serverStatisticMap.putIfAbsent(hashCode, statisticItem);
        if (statistic == null) {
            statistic = statisticItem;
        }
        QpsItem qpsItem = visitMap.computeIfAbsent(statistic, s -> new QpsItem());
        lock.putIfAbsent(statistic, new Boolean(true));
        ApiQpsStatisticsTools.updateVisitInfo(statistic, qpsItem, duration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateVisitInfo(ServiceStatisticItem statisticItem, QpsItem qpsItem, long duration) {
        Boolean bl = lock.get(statisticItem);
        synchronized (bl) {
            String threadName = Thread.currentThread().getName();
            logger.info("------------threadName :[{}] start-----------", (Object)threadName);
            qpsItem.setVisitCount(qpsItem.getVisitCount() + 1);
            if (String.valueOf(HttpStatus.OK.value()).equals(statisticItem.getHttpResponseCode())) {
                qpsItem.setMaxDurationMs(Math.max(qpsItem.getMaxDurationMs(), duration));
                qpsItem.setMinDurationMs(Math.min(qpsItem.getMinDurationMs(), duration));
                qpsItem.setAvgDurationMs(qpsItem.getAvgDurationMs() + ((double)duration - qpsItem.getAvgDurationMs()) / (double)qpsItem.getVisitCount());
            }
            logger.info("------------threadName :[{}] end--------------", (Object)threadName);
        }
    }

    public static Map<ServiceStatisticItem, QpsItem> getAndResetVisit() {
        Map<ServiceStatisticItem, QpsItem> old = visitMap;
        visitMap = Maps.newConcurrentMap();
        return old;
    }
}

