package common.base.tools.encrypt;


import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import java.security.Key;
import java.security.SecureRandom;
import java.security.Security;


/**
 * Project     : volor
 * Description :
 * Author      : Frank
 * Create Time : 2015/9/29 14:38
 */
public class AESUtils {
    private static final Logger logger = LoggerFactory.getLogger(AESUtils.class);

    private static final String KEY_ALGORITHM = "AES";
    private static final int KEY_LNE = 128;

    static {
        Security.addProvider(new BouncyCastleProvider());
    }

    public static byte[] initkey(String keyString) throws Exception {
        //实例化密钥生成器
        KeyGenerator kg = KeyGenerator.getInstance(KEY_ALGORITHM);
        //初始化密钥生成器，AES要求密钥长度为128位、192位、256位
        SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
        secureRandom.setSeed(keyString.getBytes("UTF-8"));

        kg.init(KEY_LNE, secureRandom);

//        kg.init(KEY_LNE, new SecureRandom(keyString.getBytes("UTF-8")));
        //生成密钥
        SecretKey secretKey = kg.generateKey();
        //获取二进制密钥编码形式
        return secretKey.getEncoded();
    }

    public static String generateKey(String keyString) {
        try {
            return Base64Utils.encodeURLSafe(initkey(keyString));
        } catch (Exception e) {
            logger.error("generateKey failed.", e);
            return "";
        }
    }


    /**
     * 从base64字符串解析出密钥
     *
     * @param
     * @return
     */
    public static byte[] decodeKey(String base64String) {
        return Base64Utils.decodeAsByteArray(base64String);
    }


    /**
     * 转化密钥
     *
     * @param key 密钥
     * @return Key 密钥
     * @throws Exception
     */
    public static Key codeToKey(String key) throws Exception {
        byte[] keyBytes = Base64Utils.decodeAsByteArray(key);
        SecretKey secretKey = new SecretKeySpec(keyBytes, KEY_ALGORITHM);
        return secretKey;
    }

    /**
     * 解密
     *
     * @param data 待解密数据
     * @param key  密钥
     * @return byte[] 解密数据
     * @throws Exception
     */
    public static String decrypt(byte[] data, byte[] key) throws Exception {
        //还原密钥
        Key k = new SecretKeySpec(key, KEY_ALGORITHM);
        /**
         * 实例化
         * 使用PKCS7Padding填充方式，按如下方式实现
         * Cipher.getInstance(CIPHER_ALGORITHM,"BC");
         */
        Cipher cipher = Cipher.getInstance(KEY_ALGORITHM);
        //初始化，设置解密模式
        cipher.init(Cipher.DECRYPT_MODE, k);

        //执行操作
        return new String(cipher.doFinal(data), "UTF-8");
    }

    /**
     * 解密
     *
     * @param data 待解密数据
     * @param key  密钥
     * @return byte[] 解密数据
     * @throws Exception
     */
    public static String decrypt(String data, String key) throws Exception {
        return decrypt(Base64Utils.decodeAsByteArray(data), Base64Utils.decodeAsByteArray(key));
    }

    /**
     * 加密
     *
     * @param data 待加密数据
     * @param key  密钥
     * @return bytes[] 加密数据
     * @throws Exception
     */
    public static byte[] encrypt(byte[] data, byte[] key) throws Exception {
        //还原密钥
        Key k = new SecretKeySpec(key, KEY_ALGORITHM);
        /**
         * 实例化
         * 使用PKCS7Padding填充方式，按如下方式实现
         */
        Cipher cipher = Cipher.getInstance(KEY_ALGORITHM);
        //初始化，设置为加密模式
        cipher.init(Cipher.ENCRYPT_MODE, k);
        //执行操作
        return cipher.doFinal(data);
    }

    public static String encrypt(String data, String key) throws Exception {
        byte[] dataBytes = data.getBytes("UTF-8");
        byte[] keyBytes = Base64Utils.decodeAsByteArray(key);
        return Base64Utils.encodeURLSafe(encrypt(dataBytes, keyBytes));
    }

    /**
     * @param data
     * @param key
     * @return
     * @throws Exception
     */
    public static String encrypt2(String data, String key) throws Exception {
        byte[] dataBytes = data.getBytes("UTF-8");
        byte[] keyBytes = initkey(key);
        return Base64Utils.encodeURLSafe(encrypt(dataBytes, keyBytes));
    }

    public static String decrypt2(String data, String key) throws Exception {
        byte[] dataBytes = Base64Utils.decodeAsByteArray(data);
        byte[] keyBytes = initkey(key);
        return decrypt(dataBytes, keyBytes);
    }
}

