package common.base.tools.statistics;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import common.base.tools.type.CollectionUtils;

import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;

/**
 * Created by Frank.Huang on 2016/6/3.
 */
public class CountStatisticsTools2 {
    private static String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final Map<String, Map<String, Long>> countMap = Maps.newConcurrentMap();

    public static void addCount(String name, String item, long count) {
        addCount(countMap, name, item, count);
    }

    private static void addCount(Map<String, Map<String, Long>> statMap, String key, String item, long count) {
        Map<String, Long> statCount = statMap.get(key);
        if (CollectionUtils.isNullOrEmpty(statCount)) {
            statCount = Maps.newHashMap();
            statCount.put(item, count);
            statMap.put(key, statCount);
        } else {
            Long v = statCount.get(item);
            if (v == null) {
                statCount.put(item, count);
            } else {
                statCount.replace(item, v + count);
            }
        }
    }

    public static Map<String, Map<String, Long>> getCountData() {
        return countMap;
    }

    public static String dump(boolean printPretty) {
        if (CollectionUtils.isNullOrEmpty(countMap)) {
            return "";
        }

        StringBuilder sb = new StringBuilder();

        TreeMap<String, Map<String, Long>> sortCountMap = Maps.newTreeMap(new Comparator<String>() {
            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        sortCountMap.putAll(countMap);

        sb.append(printPretty ? LINE_SEPARATOR : "\t");
        if (!CollectionUtils.isNullOrEmpty(sortCountMap)) {
            sortCountMap.forEach((k, v) -> {
                if (!CollectionUtils.isNullOrEmpty(v)) {
                    sb.append("\t");
                    sb.append(Strings.padEnd(k, 30, ' '));
                    sb.append(Joiner.on("\t").withKeyValueSeparator(":").join(v));
                    sb.append(printPretty ? LINE_SEPARATOR : "\t");
                }
            });
        }

        return sb.toString();

    }

    public static void clear() {
        countMap.clear();
    }
}
