package common.base.tools.JSON;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;

import java.io.IOException;

/**
 * Created by Frank.Huang on 2017/2/28.
 */
public class JSONTools {
    public static String toJson(Object object) throws IOException{
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writer().writeValueAsString(object);
    }

    public static <T> T fromJson(String json,Class<T> clazz) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        //TypeReference<T> typeReference = new TypeReference<T>(){};
        return objectMapper.readValue(json, clazz);
    }

    public static <T> T fromJson2(String json,TypeReference typeReference) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return objectMapper.readValue(json, typeReference);
    }

}
