package common.base.tools.api;

import com.google.common.base.Strings;
import common.base.tools.api.model.ApiBaseResponse;
import common.base.tools.exception.ApiException;
import common.base.tools.exception.ApiExceptionEx;

import java.util.Objects;

public class ApiResponseHelper {
    private static IApiErrMsgGetter iApiErrMsgGetter;

    public static void setApiErrMsgGetter(IApiErrMsgGetter iApiErrMsgGetter) {
        ApiResponseHelper.iApiErrMsgGetter = iApiErrMsgGetter;
    }

    public static void buildResponse(ApiBaseResponse response, ApiException excetion) {
        response.setRetCode(excetion.getRetCode());
        response.setErrCode(excetion.getErrCode());
        response.setMessage(excetion.getMessage());

        if (excetion instanceof ApiExceptionEx && Objects.nonNull(iApiErrMsgGetter)) {
            String msg = iApiErrMsgGetter.get(excetion.getRetCode(), excetion.getRetCode(), ((ApiExceptionEx) excetion).getId(), ((ApiExceptionEx) excetion).getLang());
            if (!Strings.isNullOrEmpty(msg)) {
                response.setMessage(msg);
            }

        }
    }

    public static ApiBaseResponse buildResponse(ApiBaseResponse response, String lang, int retCode, int errCode, String id) {
        if (Objects.isNull(response)) {
            response = new ApiBaseResponse();
        }

        response.setRetCode(retCode);
        response.setErrCode(errCode);
        if (Objects.nonNull(iApiErrMsgGetter)) {
            String msg = iApiErrMsgGetter.get(retCode, errCode, lang, id);
            response.setMessage(msg);
        }

        return response;
    }
}
