package common.base.tools.api;

import com.google.common.base.Strings;
import common.base.tools.encrypt.Base62Tools;

public interface IApiErrMsgGetter {
    String get(int retCode, int errCode, String id, String lang);

    /**
     * @param retCode
     * @param errCode
     * @return
     */
    default String buildErrCode(int retCode, int errCode) {
        long code = (retCode << 32) & errCode;
        return Long.toHexString(code);
    }

    /**
     * @param id
     * @param retCode
     * @param errCode
     * @param msg
     * @return
     */
    default String getMsg(String id, int retCode, int errCode, String msg) {
        String current = Base62Tools.longToBase62(System.currentTimeMillis());
        if (!Strings.isNullOrEmpty(msg)) {
            return ":" + msg;
        }
        if (Strings.isNullOrEmpty(id)) {
            return String.format("%s.%s.%s%s", current, retCode, errCode, msg);
        } else {
            return String.format("%s.%s.%s%s", id, current, retCode, errCode, msg);
        }
    }
}
