package common.base.tools.api.model;


import common.base.tools.AbstractPrintable;


public class ApiBaseResponse extends AbstractPrintable {
    protected int retCode = 0;
    protected int errCode = 0;
    protected String message = "";

    protected String serverSign = "";
    protected String host = "";
    protected long serverTimeMS = System.currentTimeMillis();
    protected long queryDuration = 0L;

    public boolean isSuccessful() {
        return (errCode == 0);
    }

    public void setErrMsg(int retCode, int errCode, String message) {
        this.setRetCode(retCode);
        this.setErrCode(errCode);
        this.setMessage(message);
    }

    public int getRetCode() {
        return retCode;
    }

    public void setRetCode(int retCode) {
        this.retCode = retCode;
    }

    public int getErrCode() {
        return errCode;
    }

    public void setErrCode(int errCode) {
        this.errCode = errCode;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getServerSign() {
        return serverSign;
    }

    public void setServerSign(String serverSign) {
        this.serverSign = serverSign;
    }

    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public long getServerTimeMS() {
        return serverTimeMS;
    }

    public void setServerTimeMS(long serverTimeMS) {
        this.serverTimeMS = serverTimeMS;
    }

    public long getQueryDuration() {
        return queryDuration;
    }

    public void setQueryDuration(long queryDuration) {
        this.queryDuration = queryDuration;
    }
}
