package common.base.tools.api.model;

import lombok.Data;

import java.util.Collection;

@Data
public class ApiPagingResponse<T> extends ApiResponse<T> {
    protected int totalCount = 0;
    protected int count = 0;

    protected int pageCount = 1;
    protected int pageId = 0;
    protected int pageSize = 0;

    public void setResultAndCount(T result) {
        super.setResult(result);
        if (result instanceof Collection) {
            setCount(((Collection) result).size());
        } else {
            setCount(1);
            setTotalCount(1);
        }
    }
}
