package common.base.tools.limiter;

import com.google.common.collect.Maps;

import java.util.Map;

public class RateFrequencyLimiterFactory {
    private static Map<String, RateCountAndBlockLimiter> limiterMap = Maps.newHashMap();

    /**
     * create limiter
     *
     * @param limiterName
     * @param countTimeUint
     * @param countMax
     * @param blockTimeUint
     * @param blockMax
     * @return
     */
    public static RateCountAndBlockLimiter getOrCreateLimiter(String limiterName,
                                                          int countTimeUint,
                                                          int countMax,
                                                          int blockTimeUint,
                                                          int blockMax) {
        RateCountAndBlockLimiter limiter = limiterMap.get(limiterName);
        if (limiter == null) {
            limiter = new RateCountAndBlockLimiter(limiterName,
                countTimeUint,
                countMax,
                blockTimeUint,
                blockMax);
            synchronized (limiterMap) {
                limiterMap.put(limiterName, limiter);

            }
        }
        return limiter;
    }
}
