package common.base.tools.multithread;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.concurrent.BlockingQueue;

/**
 * Created by Frank.Huang on 2016/5/5.
 */
@Deprecated
public class ChangedRunner implements IChangedRunner {

    private static final Logger logger = LoggerFactory.getLogger(ChangedRunner.class);

    private BlockingQueue queue ;
    private IChangedProcessor changedProcessor;

    public ChangedRunner(BlockingQueue queue, IChangedProcessor changedProcessor) {
        this.queue = queue;
        this.changedProcessor = changedProcessor;
        if (this.changedProcessor==null){
            throw new IllegalArgumentException("Processor is null.");
        }

    }

    @Override
    public void run() {
        Object element = queue.poll();
        while (element != null){

            try{
                changedProcessor.onStart(element);
                changedProcessor.onChanged(element);
            }catch (Exception e){
                changedProcessor.onError(element, e);
            }finally {
                changedProcessor.onEnd(element);
            }

            element = queue.poll();
        }
    }
}
