package common.base.tools.token;

import common.base.tools.token.serializer.ITokenSerializer;
import common.base.tools.token.serializer.TokenJsonSerializer;

import java.util.Objects;

public class TokenObject extends TokenValueObject {

    private final static String TOKEN_FIELD_VERSION = "V";
    private final static String TOKEN_FIELD_CREATE_TS = "CTS";
    private final static String TOKEN_FIELD_EXPIRE_TS = "ETS";

    private ITokenSerializer iSerializer;

    public TokenObject() {
        iSerializer = new TokenJsonSerializer();
    }

    public TokenObject(ITokenSerializer iTokenSerializer) {
        if (Objects.isNull(iTokenSerializer)) {
            this.iSerializer = new TokenJsonSerializer();
        } else {
            this.iSerializer = iTokenSerializer;
        }
    }

    public String serialization() {
        return iSerializer.serializer(this);
    }

    public TokenObject deserialization(String tokenString) {
        return iSerializer.deserializer(tokenString, this);
    }


    public TokenObject set(String key, String value) {
        valueMap.put(key, value);
        return this;
    }

    public TokenObject set(String key, Long value) {
        valueMap.put(key, value);
        return this;
    }

    public TokenObject setVersion(long value) {
        valueMap.put(TOKEN_FIELD_VERSION, value);
        return this;
    }

    public TokenObject setCreateTime(long value) {
        valueMap.put(TOKEN_FIELD_CREATE_TS, value);
        return this;
    }

    public TokenObject setCreateTime() {
        valueMap.put(TOKEN_FIELD_CREATE_TS, System.currentTimeMillis());
        return this;
    }

    public TokenObject setExpireTime(long value) {
        valueMap.put(TOKEN_FIELD_EXPIRE_TS, value);
        return this;
    }

    public long getVersion() {
        Long value = getLongValue(TOKEN_FIELD_VERSION);
        if (Objects.nonNull(value)) {
            return value;
        } else {
            return 0;
        }
    }

    public long getCreateTime() {
        Long value = getLongValue(TOKEN_FIELD_CREATE_TS);
        if (Objects.nonNull(value)) {
            return value;
        } else {
            return 0;
        }
    }

    public long getExpireTime() {
        Long value = getLongValue(TOKEN_FIELD_EXPIRE_TS);
        if (Objects.nonNull(value)) {
            return value;
        } else {
            return 0;
        }
    }


    public <T> T getValue(String key, Class valueType) {
        Object value = valueMap.get(key);
        if (Objects.isNull(value)) {
            return null;
        }

        if (value.getClass() == valueType) {
            return (T) value;
        } else {
            return null;
        }
    }

    public String getStringValue(String key) {
        return getValue(key, String.class);
    }

    public long getLongValue(String key) {
        return getValue(key, Long.class);
    }

    public Object getValue(String key) {
        return valueMap.get(key);
    }
}
