package common.base.tools.token.serializer;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import common.base.tools.JSON.GsonTypeAdapter;
import common.base.tools.token.TokenObject;

import java.util.Map;
import java.util.Objects;

public class TokenJsonSerializer implements ITokenSerializer {
    private Gson gson = new GsonBuilder().
        registerTypeAdapter(new TypeToken<Map<String, Object>>() {
        }.getType(), new GsonTypeAdapter())
        .create();

    @Override
    public String serializer(TokenObject tokenObject) {
        return gson.toJson(tokenObject.getValueMap());
    }

    @Override
    public TokenObject deserializer(String tokenString, TokenObject tokenObject) {
        Map<String, Object> valueMap = gson.fromJson(tokenString, new TypeToken<Map<String, Object>>() {
        }.getType());

        if (Objects.isNull(tokenObject)) {
            tokenObject = new TokenObject();
        }
        tokenObject.setValueMap(valueMap);
        return tokenObject;
    }
}
