/*
 * Decompiled with CFR 0.152.
 */
package common.base.tools.limiter;

import common.base.tools.limiter.AbstractRateLimiter;
import common.base.tools.limiter.RateLimiterTools;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RateCountLimiter
extends AbstractRateLimiter<String, AtomicLong> {
    private static final Logger logger = LoggerFactory.getLogger(RateCountLimiter.class);

    public RateCountLimiter(String limiterName, int timeUnitSeconds, int maxPerTimeUnit) {
        super(limiterName, timeUnitSeconds, maxPerTimeUnit);
    }

    @Override
    public String getKey(String key) {
        if (this.timeUnitSeconds > 0) {
            return RateLimiterTools.getPeriodKey(key, this.timeUnitSeconds);
        }
        return key;
    }

    @Override
    public long incAndGetCount(String key, AtomicLong value) {
        if (value == null) {
            value = new AtomicLong(0L);
        }
        long count = value.incrementAndGet();
        this.limitCache.put((Object)key, (Object)value);
        return count;
    }

    @Override
    public long getCount(AtomicLong count) {
        if (count == null) {
            return 0L;
        }
        return count.get();
    }
}

