package common.base.tools.compress;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

@Deprecated
public class GZipUtils {

	private static final Logger LOG = LoggerFactory.getLogger(GZipUtils.class);

	// 压缩
	public static String compress(String str) {
		if (str == null || str.length() == 0) {
			return str;
		}
		try {
			ByteArrayOutputStream out = new ByteArrayOutputStream();
			GZIPOutputStream gzip = new GZIPOutputStream(out);
			gzip.write(str.getBytes());
			gzip.close();
			return out.toString("ISO-8859-1");
		} catch (Exception e) {
			LOG.error("Gzip compress error.{}", e);
			return "";
		}

	}

	// 解压缩
	public static String uncompress(String str) throws IOException {
		if (str == null || str.length() == 0) {
			return str;
		}
		
		ByteArrayOutputStream out = new ByteArrayOutputStream();
		ByteArrayInputStream in = new ByteArrayInputStream(str.getBytes("ISO-8859-1"));
		GZIPInputStream gunzip = new GZIPInputStream(in);
		byte[] buffer = new byte[256];
		int n;
		while ((n = gunzip.read(buffer)) >= 0) {
			out.write(buffer, 0, n);
		}
		return out.toString();
	}
	
	/*
	// 测试方法
	public static void main(String[] args) throws IOException {

		// 测试字符串
		String str = FileUtils.readFileToString(
				new File("D:\\teamwork\\git-source\\mfc-vms\\mfc-vms-cloudplay-gateway\\cache\\mpstemp\\REDBOXES\\9\\e\\9ef65174db9a3f22a26f1095dadc2822_1378610733_3_CF.mps"));

		System.out.println("原长度：" + str.length());

		System.out.println("解压缩：" + GZipUtils.uncompress(str).length());
		System.out.println(GZipUtils.uncompress(str));
	}*/
}
