package common.base.tools.exception;

import com.google.common.base.MoreObjects;

public class ApiExceptionEx extends ApiException {
    private String protocol = "";
    private String lang = "";
    private String id = "";

    public ApiExceptionEx() {
    }

    public ApiExceptionEx(int retCode, int errCode, String url, String message) {
        super(retCode, errCode, url, message);
    }

    public ApiExceptionEx(int retCode, int errCode, String message) {
        super(retCode, errCode, message);
    }

    public ApiExceptionEx(int retCode, int errCode, String message, String protocol, String lang, String id) {
        super(retCode, errCode, message);
        this.protocol = protocol;
        this.lang = protocol;
        this.id = id;
    }

    public String getId() {
        return id;
    }

    public ApiExceptionEx setId(String id) {
        this.id = id;
        return this;
    }

    public String getProtocol() {
        return protocol;
    }

    public ApiExceptionEx setProtocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    public String getLang() {
        return lang;
    }

    public ApiExceptionEx setLang(String lang) {
        this.lang = lang;
        return this;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
            .add("retCode", getRetCode())
            .add("errCode", getErrCode())
            .add("msg", getMessage())
            .add("url", getUrl())
            .add("protocol", protocol)
            .add("lang", lang)
            .add("id", id)
            .toString();
    }
}
