package common.base.tools.stat;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;

import com.metric.client.MetricAgent;
import com.metric.client.MetricConfig;
import common.base.tools.type.DateTimeTools;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

/**
 * Created by Frank.Huang on 2017/2/8.
 */
@Deprecated
public class MetricTools {
    private static final Logger logger = LoggerFactory.getLogger(MetricTools.class);
    public static String ENV_METRIC_SERVER = "metric.server";
    public static String ENV_METRIC_THREAD_POOL_SIZE = "metric.thread.pool.size";
    public static String ENV_METRIC_BUFFER_QUEUE_SIZE = "metric.buffer.queue.size";
    public static String ENV_METRIC_POST_BATCH_SIZE = "metric.post.batch.size";

    private static String  metricTable = "";
    private static final String METRIC_COUNT_SUFFIX = "_count";
    private static final String METRIC_TIME_SUFFIX = "_timeconsumed";
    private static final String METRIC_API_CALL = "_apicall";
    private static final String METRIC_QUEUE = "_queuesize";

    private static final String METRIC_ES_TIME = "_es_time";
    private static final String METRIC_ES_COUNT = "_es_time";

    private static boolean bInit = false;

    public static void setDebug(boolean debug){
        MetricAgent.setDebug(debug);
    }

    
    public static void init(String appId, String appKey, String metricServer,
                            int threadPoolSize, int bufferQueueSize, int postBatchSize) {

        if (Strings.isNullOrEmpty(metricServer)){
            logger.warn("Metric:[{}] [{}] Cannot get remote metricServer,ignore report to remote.",appId,appKey);
            return;
        }

        MetricConfig metricConfig = new MetricConfig();
        metricConfig.setAppId(appId);
        metricConfig.setAppKey(appKey);
        metricConfig.setServerUrl(metricServer);

        if (threadPoolSize > 0) {
            metricConfig.setThreadPoolSize(threadPoolSize);
        }
        
        if (bufferQueueSize > 0) {
            metricConfig.setBufferQueueSize(bufferQueueSize);
        }

        if (postBatchSize > 0) {
            metricConfig.setPostBatchSize(postBatchSize);
        }

        //metricServer = "http://metric.vmfc.host:2095";


        MetricAgent.init(metricConfig);
        bInit = true;
        metricTable = appId;
        logger.info("Metric:[{}] [{}] [{}] [{}] [{}] [{}]",
                metricConfig.getAppId(), metricConfig.getAppKey(), metricConfig.getServerUrl(),
                metricConfig.getThreadPoolSize(), metricConfig.getBufferQueueSize(), metricConfig.getPostBatchSize());
    }

    
    public static void postEvent(String metricName, Map<String,String> tags, Map<String,Object> fields){
        try {
            if (bInit){
                MetricAgent.postEvent(metricName,tags,fields);
            }
        }catch (Exception e){
            //上报异常不影响正常业务
            logger.error("Report2Metric error. tags[{}] value[{}] ex[{}]",tags,fields,e);
        }
    }

    public static void logCount(String item, Map countMap){
        String metricName = metricTable + METRIC_COUNT_SUFFIX;
        postEvent(metricName,
                ImmutableMap.of("item", item),
                countMap);
    }
    
    public static void logTimeConsumed(String item, long value){
        String metricName = metricTable+ METRIC_TIME_SUFFIX;
        postEvent(metricName,
                ImmutableMap.of("item", item),
                ImmutableMap.of("count", 1, "time_consumed", value));
    }

    public static void logApiCall(Map<String,String> tags,Map<String,Object>fields) {
        postEvent(metricTable + METRIC_API_CALL,tags,fields);
    }

    public static void logESTime(String type, String opType,int count, long value){
        String metricName = metricTable + METRIC_ES_TIME;
        postEvent(metricName,
                ImmutableMap.of("type", type,"op",opType),
                ImmutableMap.of("count", count, "time_consumed", value));
    }

    public static void logQueueSize(String queue, String item, long size) {
        String metricName = metricTable + METRIC_QUEUE;
        String queueName = (queue + "_" + item).replace("-", "_");
        postEvent(metricName,
                ImmutableMap.of("t_queue", queueName),
                ImmutableMap.of("f_size", size));
    }

    public static void reportActivated(String clientIp,
                                       String did,
                                       int userStatus,
                                       String ccType,
                                       String ccMethod,
                                       String ccStatus) {
        String metricName = metricTable + "_cc";
        Map<String,String> tags = new ImmutableMap.Builder()
                .put("m_client_ip",clientIp)
                .put("t_user_status", userStatus + "")
                .put("t_method", ccMethod)
                .put("t_status", ccStatus)
                .put("t_cct", ccType)
                .put("t_cc_date", DateTimeTools.currentDateStr2())
                .build();
        
        postEvent(metricName, tags,
                ImmutableMap.of("f_did", did, "f_ccts", System.currentTimeMillis()));

    }

    public static void reportLAC(String did,
                                 String clientIp,
                                 String clientRegion,
                                 boolean isPremit) {

        if (isPremit){
            return;
        }
        
        try{
            String metricName = metricTable + "_LAC";
            Map<String,String> tags = new ImmutableMap.Builder()
                    .put("m_client_ip",clientIp)
                    .put("m_client_region", clientRegion)
                    .put("t_cc_date", DateTimeTools.currentDateStr2())
                    .build();

            postEvent(metricName, tags,
                    ImmutableMap.of("f_did", did));

        }catch (Exception e){
            logger.error("reportLAC exception:{}",e.getMessage());
        }

    }
}
