package common.base.tools.compress;

import com.google.common.base.Strings;
import common.base.tools.stat.StatTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class GZipTools {

    private static final Logger logger = LoggerFactory.getLogger(GZipTools.class);

    private static final int GZIP_READ_BLOCK_SIZE = 1024;

    public static final String GZIP_ENCODE_UTF_8 = "UTF-8";
    public static final String GZIP_ENCODE_ISO_8859_1 = "ISO-8859-1";
    public static final String GZIP_ENCODE = GZIP_ENCODE_ISO_8859_1;//GZIP_ENCODE_UTF_8;


    // 压缩
    public static String compress(String str) {
        if (Strings.isNullOrEmpty(str)) {
            return "";
        }

        StatTools.startSrvTimer("gzip.compress");
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();
             GZIPOutputStream gzip = new GZIPOutputStream(out)) {
            gzip.write(str.getBytes());
            gzip.close();
            return out.toString(GZIP_ENCODE);
        } catch (Exception e) {
            logger.error("Gzip compress exception str[{}] err[{}] ", str, e);
            return "";
        } finally {
            StatTools.stopSrvTimer("gzip.compress");
        }
    }

    // 解压缩
    public static String decompress(String str) {
        if (Strings.isNullOrEmpty(str)) {
            return "";
        }

        try (ByteArrayOutputStream out = new ByteArrayOutputStream();
             ByteArrayInputStream in = new ByteArrayInputStream(str.getBytes(GZIP_ENCODE));
             GZIPInputStream ungzip = new GZIPInputStream(in)) {
            byte[] buffer = new byte[GZIP_READ_BLOCK_SIZE];
            int n = -1;
            while ((n = ungzip.read(buffer)) >= 0) {
                out.write(buffer, 0, n);
            }

            ungzip.close();
            return out.toString(GZIP_ENCODE);
        } catch (IOException e) {
            logger.error("Gzip decompress exception. str[{}] err[{}] ", str, e);
            return "";
        }
    }


//    // 压缩
//    public static byte[] compress(byte[] bytes) {
//        if (bytes.length == 0) {
//            return new byte[0];
//        }
//
//        try (ByteArrayOutputStream out = new ByteArrayOutputStream();
//             GZIPOutputStream gzip = new GZIPOutputStream(out)) {
//            gzip.write(bytes);
//            gzip.close();
//            return out.toByteArray();
////            return out.toString(GZIP_ENCODE);
//        } catch (Exception e) {
//            logger.error("Gzip compress exception str[{}] err[{}] ", bytes, e);
//            return new byte[0];
//        }
//
//    }
//
//    // 解压缩
//    public static byte[] decompress(byte[] bytes) {
//        if (bytes.length == 0) {
//            return new byte[0];
//        }
//
//        try (ByteArrayOutputStream out = new ByteArrayOutputStream();
//             ByteArrayInputStream in = new ByteArrayInputStream(bytes);
//             GZIPInputStream ungzip = new GZIPInputStream(in)) {
//            byte[] buffer = new byte[GZIP_READ_BLOCK_SIZE];
//            int n = -1;
//            while ((n = ungzip.read(buffer)) >= 0) {
//                out.write(buffer, 0, n);
//            }
//
//            ungzip.close();
//            return out.toByteArray();
//            //return out.toString(GZIP_ENCODE);
//        } catch (IOException e) {
//            logger.error("Gzip decompress exception. str[{}] err[{}] ", bytes, e);
//            return new byte[0];
//        }
//    }
	/*
	// 测试方法
	public static void main(String[] args) throws IOException {

		// 测试字符串
		String str = FileUtils.readFileToString(
				new File("D:\\teamwork\\git-source\\mfc-vms\\mfc-vms-cloudplay-gateway\\cache\\mpstemp\\REDBOXES\\9\\e\\9ef65174db9a3f22a26f1095dadc2822_1378610733_3_CF.mps"));

		System.out.println("原长度：" + str.length());

		System.out.println("解压缩：" + GZipUtils.uncompress(str).length());
		System.out.println(GZipUtils.uncompress(str));
	}*/
}
