package common.base.tools.statistics;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;

import java.util.Map;

/**
 * Created by Frank.Huang on 2016/5/10.
 */
public class StatTimeItem {

    private String key = "";
    private long count = 0;
    private long time = 0;
    private long max = 0;
    private long min = 0;
    private Map<Integer, Long> rangeStat = Maps.newHashMap();

    public Map<Integer, Long> getRanges() {
        return rangeStat;
    }

    public void setRanges(Map<Integer, Long> ranges) {
        this.rangeStat = ranges;
    }

    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public long getCount() {
        return count;
    }

    public long getTime() {
        return time;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public long getMax() {
        return max;
    }

    public void setMax(long max) {
        this.max = max;
    }

    public long getMin() {
        return min;
    }

    public void setMin(long min) {
        this.min = min;
    }

    public Map<Integer, Long> getRangeStat() {
        return rangeStat;
    }

    public void setRangeStat(Map<Integer, Long> rangeStat) {
        this.rangeStat = rangeStat;
    }

    public void AddRangeStat(long time) {
        int level = StatRangeTools.getLevel(time);
        long count = rangeStat.getOrDefault(level, 0L);
        count++;
        rangeStat.put(level, count);
    }

    public void addCount(long count) {
        this.count += count;
    }

    public void addTime(long time) {
        this.time += time;

        if (max == 0 && time > max) {
            max = time;
        }

        if (min == 0 || time < min) {
            min = time;
        }

        AddRangeStat(time);
    }

    public long avg() {
        if (count == 0) {
            return 0;
        } else {
            return time / count;
        }
    }

    public String rangeStat() {
        StringBuilder sb = new StringBuilder();
        rangeStat.forEach((k, v) -> {
            sb.append("");
            sb.append(Strings.padEnd(StatRangeTools.getRangeName(k), 10, ' '));
            sb.append(":");
            sb.append(Strings.padEnd(v + "", 5, ' '));
        });

        return sb.toString();
    }

    public long getCountGELevel(int level) {
        final int[] count = {0};
        rangeStat.forEach((k, v) -> {
            if (k >= level) {
                count[0] += v;
            }
        });

        return count[0];
    }


}
