/*
 * Decompiled with CFR 0.152.
 */
package common.base.tools.token;

import common.base.tools.token.TokenValueObject;
import common.base.tools.token.serializer.ITokenSerializer;
import common.base.tools.token.serializer.TokenJsonSerializer;
import java.util.Objects;

public class TokenObject
extends TokenValueObject {
    private static final String TOKEN_FIELD_VERSION = "V";
    private static final String TOKEN_FIELD_CREATE_TS = "CTS";
    private static final String TOKEN_FIELD_EXPIRE_TS = "ETS";
    private ITokenSerializer iSerializer;

    public TokenObject() {
        this.iSerializer = new TokenJsonSerializer();
    }

    public TokenObject(ITokenSerializer iTokenSerializer) {
        this.iSerializer = Objects.isNull(iTokenSerializer) ? new TokenJsonSerializer() : iTokenSerializer;
    }

    public String serialization() {
        return this.iSerializer.serializer(this);
    }

    public TokenObject deserialization(String tokenString) {
        return this.iSerializer.deserializer(tokenString, this);
    }

    public TokenObject set(String key, String value) {
        this.valueMap.put(key, value);
        return this;
    }

    public TokenObject set(String key, Long value) {
        this.valueMap.put(key, value);
        return this;
    }

    public TokenObject setVersion(long value) {
        this.valueMap.put(TOKEN_FIELD_VERSION, value);
        return this;
    }

    public TokenObject setCreateTime(long value) {
        this.valueMap.put(TOKEN_FIELD_CREATE_TS, value);
        return this;
    }

    public TokenObject setCreateTime() {
        this.valueMap.put(TOKEN_FIELD_CREATE_TS, System.currentTimeMillis());
        return this;
    }

    public TokenObject setExpireTime(long value) {
        this.valueMap.put(TOKEN_FIELD_EXPIRE_TS, value);
        return this;
    }

    public long getVersion() {
        Long value = this.getLongValue(TOKEN_FIELD_VERSION);
        if (Objects.nonNull(value)) {
            return value;
        }
        return 0L;
    }

    public long getCreateTime() {
        Long value = this.getLongValue(TOKEN_FIELD_CREATE_TS);
        if (Objects.nonNull(value)) {
            return value;
        }
        return 0L;
    }

    public long getExpireTime() {
        Long value = this.getLongValue(TOKEN_FIELD_EXPIRE_TS);
        if (Objects.nonNull(value)) {
            return value;
        }
        return 0L;
    }

    public <T> T getValue(String key, Class valueType) {
        Object value = this.valueMap.get(key);
        if (Objects.isNull(value)) {
            return null;
        }
        if (value.getClass() == valueType) {
            return (T)value;
        }
        return null;
    }

    public String getStringValue(String key) {
        return (String)this.getValue(key, String.class);
    }

    public long getLongValue(String key) {
        return (Long)this.getValue(key, Long.class);
    }

    public Object getValue(String key) {
        return this.valueMap.get(key);
    }
}

