/*
 * Decompiled with CFR 0.152.
 */
package common.base.tools.token;

import com.google.common.base.Strings;
import common.base.tools.encrypt.AESUtils;
import common.base.tools.exception.ApiException;
import common.base.tools.token.TokenObject;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenTools {
    private static final Logger logger = LoggerFactory.getLogger(TokenTools.class);
    private static final int TOKEN_MODULE_CODE = 1020;
    private static final int TOKEN_ILLEGAL = 1;
    private static final int TOKEN_EXPIRE = 2;
    private static final int TOKEN_VALUE_MISMATCH = 3;
    private static final int TOKEN_VALUE_MISSING = 4;

    public static String encodeToken(String key, TokenObject tokenObject) {
        String tokenStr = tokenObject.serialization();
        try {
            String encodeKey = AESUtils.generateKey(key);
            if (!Strings.isNullOrEmpty((String)encodeKey)) {
                return AESUtils.encrypt(tokenStr, encodeKey);
            }
        }
        catch (Exception e) {
            logger.error("[TokenTools] build exception[{}]", (Object)tokenObject, (Object)e);
        }
        return "";
    }

    public static TokenObject decodeToken(String key, String tokenStr) throws ApiException {
        try {
            String encodeKey = AESUtils.generateKey(key);
            if (!Strings.isNullOrEmpty((String)encodeKey)) {
                String decodeStr = AESUtils.decrypt(tokenStr, encodeKey);
                TokenObject tokenObject = new TokenObject();
                return tokenObject.deserialization(decodeStr);
            }
        }
        catch (Exception e) {
            logger.error("[TOKEN]TOKEN_ILLEGAL:[{}]", (Object)tokenStr, (Object)e);
            throw new ApiException(1020, 1, "TOKEN_ILLEGAL");
        }
        return null;
    }

    public static boolean checkToken(String key, String tokenStr, Map<String, Object> checkValueMap) throws ApiException {
        TokenObject tokenObject = TokenTools.decodeToken(key, tokenStr);
        if (tokenObject == null) {
            return false;
        }
        return TokenTools.checkToken(tokenObject, checkValueMap);
    }

    public static boolean checkToken(TokenObject tokenObject, Map<String, Object> checkValueMap) throws ApiException {
        long tokenExpireTime = tokenObject.getExpireTime();
        if (tokenExpireTime > 0L && tokenExpireTime < System.currentTimeMillis()) {
            logger.error("[TOKEN]TOKEN_EXPIRE:[{}]", (Object)tokenObject.toString());
            throw new ApiException(1020, 2, "TOKEN_EXPIRE");
        }
        for (String key : checkValueMap.keySet()) {
            Object value = checkValueMap.get(key);
            if (Objects.isNull(value)) continue;
            Object tokenValue = tokenObject.getValue(key);
            if (Objects.isNull(tokenValue)) {
                logger.error("[TOKEN]TOKEN_VALUE_MISSING:[{}] key[{}]", (Object)tokenObject.toString(), (Object)key);
                throw new ApiException(1020, 4, "TOKEN_VALUE_MISSING");
            }
            if (value.getClass() != tokenValue.getClass()) {
                logger.error("[TOKEN]TOKEN_VALUE_MISMATCH:[{}] key[{}][{}<>{}]", new Object[]{tokenObject.toString(), key, value.getClass(), tokenValue.getClass()});
                throw new ApiException(1020, 3, "TOKEN_VALUE_MISMATCH");
            }
            boolean checkValue = false;
            if (value instanceof Long) {
                if (((Long)value).compareTo((Long)tokenValue) == 0) {
                    checkValue = true;
                }
            } else if (value instanceof String) {
                if (((String)value).contentEquals((String)tokenValue)) {
                    checkValue = true;
                }
            } else if (value.equals(tokenValue)) {
                checkValue = true;
            }
            if (checkValue) continue;
            logger.error("[TOKEN]TOKEN_VALUE_MISMATCH:[{}] key[{}][{}<>{}]", new Object[]{tokenObject.toString(), key, value, tokenValue});
            throw new ApiException(1020, 3, "TOKEN_VALUE_MISMATCH");
        }
        return true;
    }
}

