/*
 * Decompiled with CFR 0.152.
 */
package common.base.tools.uniqueID;

import com.google.common.base.Strings;
import common.base.tools.sys.SystemTools;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniqueIdGenerator {
    private static final Logger logger = LoggerFactory.getLogger(UniqueIdGenerator.class);
    private static final long START_TIMESTAMP = 1598889600000L;
    private static final long SEQUENCE_BIT = 12L;
    private static final long MACHINE_BIT = 5L;
    private static final long DATACENTER_BIT = 5L;
    private static final long MAX_DATACENTER_NUM = 31L;
    private static final long MAX_MACHINE_NUM = 31L;
    private static final long MAX_SEQUENCE = 4095L;
    private static final long SEQUENCE_STEP_SIZE = 1024L;
    private long basicSequence = 0L;
    private static final long MACHINE_LEFT = 12L;
    private static final long DATACENTER_LEFT = 17L;
    private static final long TIMESTMP_LEFT = 22L;
    private long datacenterId;
    private long machineId;
    private long sequence = 0L;
    private long lastTimestamp = -1L;

    public static UniqueIdGenerator getInstance(long datacenterId, long machineId) {
        UniqueIdGeneratorInstance.instance.setWorkId(datacenterId, machineId);
        return UniqueIdGeneratorInstance.instance;
    }

    private UniqueIdGenerator() {
    }

    public void setWorkId(long datacenterId, long machineId) {
        this.setDatacenterId(datacenterId);
        this.setMachineId(machineId);
        logger.info("UniqueIdBuilder:datacenterId:[{}] machineId:[{}]", (Object)this.datacenterId, (Object)this.machineId);
    }

    private long setMachineId(long machineId) {
        if (machineId > 0L && machineId <= 31L) {
            this.machineId = machineId;
            return this.machineId;
        }
        String machineStr = this.getMachineStr();
        this.machineId = Math.abs(machineStr.hashCode() % 31);
        logger.info("UniqueIdGenerator:MachineId[{}] MachineStr[{}]", (Object)this.machineId, (Object)machineStr);
        return this.machineId;
    }

    private long setDatacenterId(long datacenterId) {
        if (datacenterId > 0L && datacenterId <= 31L) {
            this.datacenterId = datacenterId;
            return this.datacenterId;
        }
        String dataCenterStr = this.getDatacenterStr();
        this.datacenterId = Math.abs(dataCenterStr.hashCode() % 31);
        logger.info("UniqueIdGenerator:datacenterId[{}] dataCenterStr[{}]", (Object)this.datacenterId, (Object)dataCenterStr);
        return datacenterId;
    }

    private String getDatacenterStr() {
        String hostName = Strings.nullToEmpty((String)SystemTools.getHostname());
        String ipList = Strings.nullToEmpty((String)SystemTools.getIpAddress());
        String str = "";
        str = Strings.isNullOrEmpty((String)hostName) && Strings.isNullOrEmpty((String)ipList) ? UUID.randomUUID().toString() : hostName + "@" + ipList;
        return str;
    }

    private String getMachineStr() {
        int pid = SystemTools.getCurrentPid();
        if (pid == -1) {
            pid = UUID.randomUUID().hashCode();
        }
        return this.getDatacenterStr() + "@" + pid;
    }

    public synchronized long nextId() {
        long currentTimestamp = this.getNewTimestamp();
        if (currentTimestamp < this.lastTimestamp) {
            logger.warn("UniqueIdBuilder:Clock moved backwards.currentTimestamp:[{}],lastStmp[{}],Offset[{}]", new Object[]{currentTimestamp, this.lastTimestamp, currentTimestamp - this.lastTimestamp});
            this.basicSequence += 1024L;
            if (this.basicSequence > 4095L) {
                this.basicSequence = 0L;
                currentTimestamp = this.getNextMill();
            }
        }
        if (currentTimestamp == this.lastTimestamp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                currentTimestamp = this.getNextMill();
            }
        } else {
            this.sequence = this.basicSequence;
        }
        this.lastTimestamp = currentTimestamp;
        return currentTimestamp - 1598889600000L << 22 | this.datacenterId << 17 | this.machineId << 12 | this.sequence;
    }

    private long getNextMill() {
        long mill = this.getNewTimestamp();
        while (mill <= this.lastTimestamp) {
            mill = this.getNewTimestamp();
        }
        return mill;
    }

    private long getNewTimestamp() {
        return System.currentTimeMillis();
    }

    private static class UniqueIdGeneratorInstance {
        private static final UniqueIdGenerator instance = new UniqueIdGenerator();

        private UniqueIdGeneratorInstance() {
        }
    }
}

