package common.config.tools.config;

import com.google.common.collect.ImmutableSet;
import common.config.tools.file.monitor.PathFileMonitor;
import common.config.tools.file.monitor.PropertyFileListener;

import java.util.Set;

/**
 * Created by Frank.Huang on 2017/7/6.
 */
public class ConfigTools3 extends ConfigTools2 {

    public static void load(String filePath, String fileNamePattern, Set<String> extSet, final boolean recursive) {
        new PathFileMonitor(interval)
                .monitorPath(replaceDirectoryPath(filePath), fileNamePattern, extSet, new PropertyFileListener(false, configMap), recursive)
                .start();

    }

    public static void load(String dir, Set<String> extSet) {
        load(dir, null, extSet, true);
    }
    
    public static void load(String dir) {
        load(dir, null, ImmutableSet.of("config", "properties"), true);
    }

    public static void load() {
        load("config");
    }


}
