/*
 * Decompiled with CFR 0.152.
 */
package common.config.tools.config;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConfigTools {
    private static final Logger logger = LoggerFactory.getLogger(AbstractConfigTools.class);
    private static final String SPLIT_STR = ",";
    protected static Map<String, String> configMap = Maps.newLinkedHashMap();
    protected static long interval = 60000L;
    protected static boolean enableEnv = true;

    public static void enableEnv(boolean enableEnv) {
        AbstractConfigTools.enableEnv = enableEnv;
    }

    public static void setInterval(long interval) {
        AbstractConfigTools.interval = interval;
    }

    public static String getString(String key) {
        String value = configMap.get(key);
        if (value == null && enableEnv) {
            value = System.getenv(key);
        }
        return Strings.nullToEmpty((String)value);
    }

    public static String getString(String key, String defaultValue) {
        String value = AbstractConfigTools.getString(key);
        if (Strings.isNullOrEmpty((String)value)) {
            return defaultValue;
        }
        return value;
    }

    public static List<String> getAsList(String key, String split) {
        String value = AbstractConfigTools.getString(key);
        if (Strings.isNullOrEmpty((String)value)) {
            return Lists.newArrayList();
        }
        try {
            return Splitter.on((String)split).omitEmptyStrings().splitToList((CharSequence)value);
        }
        catch (Exception e) {
            return Lists.newArrayList();
        }
    }

    public static List<String> getAsList(String key) {
        return AbstractConfigTools.getAsList(key, SPLIT_STR);
    }

    public static Long getLong(String key, Long defaultValue) {
        String strValue = AbstractConfigTools.getString(key);
        if (Strings.isNullOrEmpty((String)strValue)) {
            return defaultValue;
        }
        try {
            return Long.parseLong(strValue);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static Long getLong(String key) {
        return AbstractConfigTools.getLong(key, null);
    }

    public static Integer getInt(String key, Integer defaultValue) {
        String strValue = AbstractConfigTools.getString(key);
        if (Strings.isNullOrEmpty((String)strValue)) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(strValue);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static Integer getInt(String key) {
        return AbstractConfigTools.getInt(key, null);
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        String value = AbstractConfigTools.getString(key);
        if (Strings.isNullOrEmpty((String)value)) {
            return defaultValue;
        }
        return "true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value) || "y".equalsIgnoreCase(value) || "1".equalsIgnoreCase(value);
    }

    public static boolean getAsBoolean(String key, boolean defaultValue) {
        return AbstractConfigTools.getBoolean(key, defaultValue);
    }

    public static Map<String, String> getAsMap(String key, String itemSeparator, String keyValueSeparator) {
        String value = null;
        try {
            value = AbstractConfigTools.getString(key);
            if (!Strings.isNullOrEmpty((String)value)) {
                itemSeparator = Strings.isNullOrEmpty((String)itemSeparator) ? "&" : itemSeparator;
                keyValueSeparator = Strings.isNullOrEmpty((String)keyValueSeparator) ? ":" : keyValueSeparator;
                return Splitter.on((String)itemSeparator).withKeyValueSeparator(keyValueSeparator).split((CharSequence)value);
            }
        }
        catch (Exception e) {
            logger.error("Splitter [{}-{}] [{}] to map exception", new Object[]{itemSeparator, keyValueSeparator, value, e.getMessage()});
        }
        return null;
    }

    public static Map<String, String> getAsMap(String key) {
        return AbstractConfigTools.getAsMap(key, "&", "=");
    }

    public static Map<String, String> getAllConfig() {
        return configMap;
    }

    public static String replaceDirectoryPath(String path) {
        if (Strings.isNullOrEmpty((String)path)) {
            return path;
        }
        return path.replace("${user.home}", FileUtils.getUserDirectoryPath()).replace("${java.io.tmpdir}", FileUtils.getTempDirectoryPath());
    }

    public static String getConfigAsString(String key, String defaultValue) {
        return AbstractConfigTools.getString(key, defaultValue);
    }

    public static String getConfigAsString(String key) {
        return AbstractConfigTools.getString(key, "");
    }

    public static Long getConfigAsLong(String key, Long defaultValue) {
        return AbstractConfigTools.getLong(key, defaultValue);
    }

    public static Long getConfigAsLong(String key) {
        return AbstractConfigTools.getLong(key, null);
    }

    public static Integer getConfigAsInt(String key, Integer defaultValue) {
        return AbstractConfigTools.getInt(key, defaultValue);
    }

    public static Integer getConfigAsInt(String key) {
        return AbstractConfigTools.getInt(key, null);
    }
}

