package common.config.tools.config.loader.properties;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.common.io.LineProcessor;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;

/**
 * Created by Frank.Huang on 2017/5/4.
 */
public class PropertiesLoader2 {
    private static final Logger logger = LoggerFactory.getLogger(PropertiesLoader2.class);
    private static final String FILE_CODING = "utf-8";

    public static Map<String, String> loader(File file) throws IOException {
        logger.info("Load File:[{}]", file.getAbsoluteFile());
        Map<String, String> resultMap = Files.readLines(file, Charset.forName(FILE_CODING), new LineProcessor<Map<String, String>>() {
            Map<String, String> resultMap = Maps.newLinkedHashMap();

            @Override
            public boolean processLine(String line) throws IOException {
                if (!Strings.isNullOrEmpty(line)) {
                    if (!line.startsWith("#")) {
                        int pos = line.indexOf("=");
                        if (pos != -1) {
                            String key = Strings.nullToEmpty(line.substring(0, pos)).trim();
                            String value = Strings.nullToEmpty(line.substring(pos + 1).trim());
                            resultMap.put(key, value);
                            logger.info("Load properties: [{}={}]", key, value);
                        }
                    }
                }

                return true;
            }

            @Override
            public Map<String, String> getResult() {
                return resultMap;
            }
        });

        return resultMap;
    }
}
