package common.config.tools.file.monitor;

import org.apache.commons.io.filefilter.AbstractFileFilter;

import java.io.File;
import java.util.regex.Pattern;

/**
 * Created by Frank.Huang on 2017/7/3.
 */
public class FileNameFilter extends AbstractFileFilter implements IFileChangedFilter {
    protected String fnp;

    public FileNameFilter(String fn) {
        this.fnp = fn;
    }

    @Override
    public boolean accept(File file) {
        if (!file.isFile()){
            return false;
        }

        return accept(fnp, file.getName());
    }

    @Override
    public boolean accept(File dir, String name) {
        return accept(fnp,name);
    }

    public boolean accept(String fnp,String fn){
        fnp = fnp.replace('.', '#');
        fnp = fnp.replaceAll("#", "\\\\.");
        fnp = fnp.replace('*', '#');
        fnp = fnp.replaceAll("#", ".*");
        fnp = fnp.replace('?', '#');
        fnp = fnp.replaceAll("#", ".?");
        fnp = "^" + fnp + "$";

        Pattern p = Pattern.compile(fnp);
        if (p.matcher(fn).matches()){
            return true;
        }else {
            return false;
        }
    }
}

